/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.network;

import com.google.common.collect.Maps;
import com.jaquadro.minecraft.storagedrawers.config.PlayerConfig;
import com.jaquadro.minecraft.storagedrawers.config.PlayerConfigSetting;
import com.texelsaurus.minecraft.chameleon.network.ChameleonPacket;
import com.texelsaurus.minecraft.chameleon.network.ChameleonPacketHandler;
import java.util.HashMap;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public record PlayerBoolConfigMessage(String uuid, String key, boolean value) implements ChameleonPacket<PlayerBoolConfigMessage>
{
    public static final class_2960 ID = new class_2960("storagedrawers", "player_bool_config");
    public static final Handler HANDLER = new Handler();

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public ChameleonPacketHandler<PlayerBoolConfigMessage> getHandler() {
        return HANDLER;
    }

    private static class Handler
    implements ChameleonPacketHandler<PlayerBoolConfigMessage> {
        private Handler() {
        }

        @Override
        public Class<PlayerBoolConfigMessage> type() {
            return PlayerBoolConfigMessage.class;
        }

        @Override
        public void encode(PlayerBoolConfigMessage message, class_2540 buffer) {
            buffer.method_10814(message.uuid);
            buffer.method_10814(message.key);
            buffer.writeBoolean(message.value);
        }

        @Override
        public PlayerBoolConfigMessage decode(class_2540 buffer) {
            String uuid = buffer.method_19772();
            String key = buffer.method_19772();
            boolean value = buffer.readBoolean();
            return new PlayerBoolConfigMessage(uuid, key, value);
        }

        @Override
        public void handle(PlayerBoolConfigMessage message, class_1657 player, Consumer<Runnable> workQueue) {
            if (player instanceof class_3222) {
                workQueue.accept(() -> {
                    UUID playerUniqueId;
                    try {
                        playerUniqueId = UUID.fromString(message.uuid);
                    }
                    catch (IllegalArgumentException e) {
                        return;
                    }
                    HashMap clientMap = PlayerConfig.serverPlayerConfigSettings.get(playerUniqueId);
                    if (clientMap == null) {
                        clientMap = Maps.newHashMap();
                    }
                    clientMap.put(message.key, new PlayerConfigSetting<Boolean>(message.key, message.value, playerUniqueId));
                    PlayerConfig.serverPlayerConfigSettings.put(playerUniqueId, clientMap);
                });
            }
        }
    }
}

